<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AddNotificationRequest;

class NotificationController extends Controller
{
    public function __construct()
    {
        $this->model="App\Models\Notification";
        $this->User="App\Models\User";
    }

    public function index(){
        $notifications=$this->model::latest()->get();
        $consultants=$this->User::consultant()->get(['id','name']);
        return view('admin.notifications.index',compact('notifications','consultants'));
    }

    public function store(AddNotificationRequest $request){
        $data=$request->validated();
        $this->model::create($data);
        $notification=
        [
            'type' => "1",
            'title' => $request->title_ar,
            'message' => $request->body_ar,
            'consultant_id' =>$request->consultant_id
        ];
        $this->sendNotification($data_send=$notification,$users=array());

        return  to_route('admin.notifications.index')->with('success',trans('lang.created'));
    }

    public function destroy(Request $request){
        $this->model::destroy($request->id);
        return  to_route('admin.notifications.index')->with('success',trans('lang.deleted'));
    }
            // 'app_id' => 'ebea10c6-b9d0-48a3-a8d6-b6f0d97d9d72',

    function sendNotification($data_send=array(),$users=array()){
        $content = ["en" => $data_send["message"]];
        $headings= ["en" => $data_send["title"]]; //<---- this will add heading
        $fields = array(
            'app_id' => '50fbd58c-8686-4f50-95d7-581eeaa3879f',
            'data' => $data_send,
            'isAndroid'=>true,
            'isIos'=>true,
            'content_available'=>true,
            'small_icon'    => 'ic_launcher-web',
            //'large_icon' =>"ic_launcher_round.png",
            'contents' => $content,
            'headings'=> $headings //<---- include it to request
        );

        if(empty($users))
        {
            $fields['included_segments']=array('All');
        }else
        {
            $fields['include_player_ids']=$users;
        }

        $fields = json_encode($fields);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic NzYwMDM2NjQtMzZlYy00MDEzLWEzYjQtMjBiNzhjYzIyOWRm'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        $response = curl_exec($ch);
        // var_dump($response);
        curl_close($ch);

        return $response;
    }

}
