<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class StatisticsController extends Controller
{
    public function __construct()
    {
        $this->model="App\Models\Consultation";
        $this->Section="App\Models\Section";
        $this->Consultant="App\Models\Consultant";
        $this->Country="App\Models\Country";
    }

    public function index(Request $request){
        $gender=$request->gender;

        $section_id=$request->section_id;

        $totalConsultations=$this->model::count();

        $sections=$this->Section::withCount('consultations')->get();

        $countries=$this->Country::get(['id','name']);

        $searchResult=$this->model::where('country_id',$request->country_id);

        $searchResult->when($section_id, function ($query, $section_id) {
            return $query->where('section_id',$section_id);
        })
        ->when($gender, function ($query, $gender) {
            return $query->whereHas('userInfo', function ($q) use ($gender){
                $q->where('gender',$gender);
            });
        });
        
        $searchResult=$searchResult->count();
        return view('dashboard.index',
        compact('totalConsultations','sections','countries','searchResult'));
    }
}
