<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class UsersController extends Controller
{
    public function __construct()
    {
        $this->model="App\Models\User";
    }
    
    public function index(){
        $clients=$this->model::client()->with('country')->latest()->get();
        return view('admin.clients.index',compact('clients'));
    }
    
     public function destroy(Request $request){
        $client=$this->model::destroy($request->id);
        return back()->with('success','تم الحذف بنجاح');
        
     }
     
     public function changeStatus($id){
        $client=$this->model::find($id);
        $status=$client->active ==0?1:0;
        $client->update(['active' =>$status]);
        return back()->with('success', 'تم تغيير الحالة بنجاح');
        
     }

    public function resetPassword(Request $request){
        $client=$this->model::find($request->client_id);
        $client->update(['password' => $request->password]);
        return back()->with('success',trans('lang.updated'));
    }

}
