<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\CheckPhoneExists;
use App\Http\Requests\Auth\ResetPasswordRequest;
use App\Traits\ResponsesTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\EmailController;

class ResetPasswordController extends Controller
{
    use ResponsesTrait;
    public function __construct()
    {
        $this->model="App\Models\User";
    }

    public function resetPassword(ResetPasswordRequest $request){
        $data['password']=$request->password;
        $user=$this->model::whereEmail($request->email)->first();
        $user->update($data);
        return $this->success("تم انشاء كلمة مرور جديدة");
    }

    public function sendOtp(CheckPhoneExists $request){
        $code   = rand(1111,9999);
        $details =[
            'body' => "Your otp is ",
            'title' =>"Reset Password",
            "code" => $code,
            'email' => $request->email
            ];
        EmailController::sendEmail($details);
        return $this->success($code);
    }
}
