<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Http\Requests\Auth\RegisterRequest;
use App\Traits\ResponsesTrait;
use Illuminate\Http\Request;

class UserAuthController extends Controller
{
    use ResponsesTrait;
    public function __construct()
    {
        $this->model="App\Models\User";
    }

    public function register(RegisterRequest $request){
        $data=$request->validated();
        $user = $this->model::withTrashed()->where("phone" , $request->phone)->first();
        if($user && !is_null($user->deleted_at)){

            $data['deleted_at'] = null ;
            $data['units'] = 0 ;
            $user->update($data);
        }elseif($user){

            return $this->failed( 'رقم الهاتف مسجل بالفعل');
        }
        else{
             $user = $this->model::create($data);
        }
        $user=$this->model::find($user->id);
        $user->token = $user->createToken('API Token')->accessToken;
        $user->role=1;
        return $this->success($user) ;
    }

    public function login(LoginRequest $request)
    {
        $data=$request->validated();
        unset($data['device_id']);
        if (!auth()->attempt($data)) {
            return $this->failed('معلومات الدخول غير صحيحة');
        }
        $user=auth()->user();
        if($user->active ==0){
                return $this->failed(' الرجاء التواصل مع الدعم');

        }
        $user->update(['device_id' => $request->device_id]);
        $user->token = $user->createToken('API Token')->accessToken;
        return $this->success($user) ;
    }

    public function logout(Request $request)
    {
        if(auth()->user())
        {
            auth()->user()->token()->revoke();
        }
        return $this->success("تم تسجيل الخروج بنجاح") ;
    }
}
