<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;
use App\Http\Requests\CheckDiscountRequest;

class DiscountsController extends Controller
{
    use ResponsesTrait;

    public function __construct()
    {
        $this->model = "App\Models\Discount";
        $this->UserDiscounts = "App\Models\UserDiscounts";
    }

    public function checkAvailabilty(CheckDiscountRequest $request){
        $discount=$this->model::whereCode($request->code)->first();
        if(!$discount){
            return $this->failed("The code Is Not found.");
        }

        if($discount->end_date < now() || $discount->active == 0 || $discount->used_coupons >= $discount->coupons_number){
            return $this->failed("The code Is Expired.");
        }

        $userDiscounts=$this->UserDiscounts::where(["user_id" => auth()->id(),"discount_id" => $discount->id])->count();
        if($userDiscounts >= $discount->coupons_user_number){
            return $this->failed("You have reached the maximum usage limit.");
        }
        $price=$request->price-($request->price * ($discount->value/100));
        return $this->success($price);
    }
}
