<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreConsultationRateRequest;

class EvaluationController extends Controller
{
    use ResponsesTrait;
    public function __construct()
    {
        $this->model="App\Models\Consultation";
        $this->Consultant="App\Models\Consultant";
    }

    public function store(StoreConsultationRateRequest $request){
        $data=$request->validated();
        $data['is_published']="1";
        $evaluations=$this->model::find($request->id);
        if($evaluations->is_published>0){
            return $this->failed('تم تسجيل تقييم بالفعل لهذه الاستشارة');
            
        }
        $rating_number=$request->rating_number;
        $this->Consultant::whereId($evaluations->consultant_id)->increment('rating_number',$rating_number);
        $this->Consultant::whereId($evaluations->consultant_id)->increment('consultations_number');
        $evaluations->update($data);
        return $this->success('تم الاضافة بنجاح');
    }
}
