<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;
use App\Http\Requests\CheckProductRequest;

class PackageController extends Controller
{
    use ResponsesTrait;
    public function __construct()
    {
        $this->model="App\Models\Package";
        $this->User="App\Models\User";
        $this->PackagesResource="App\Http\Resources\PackagesResource";
        $this->PackagesCreditResource="App\Http\Resources\PackagesCreditResource";

    }
    
    public function index(Request $request){
        $result= [];
        if($request->payment_method== "knet"){
            $data=$this->model::select('id','product_id','name','units','knet as price','points')
            ->get();
            $result=$this->PackagesResource::collection($data);
        }
        else if($request->payment_method== "credit" ){
            $data=$this->model::get();
            $result=$this->PackagesCreditResource::collection($data);

        }else{
            $data=$this->model::select('id','product_id','name','units','inapp_purchase_price as price','points')
            // ->where('id',14)
            ->get();
            $result=$this->PackagesResource::collection($data);
        }
        return $this->success($result);
    }

    public function payPackage(CheckProductRequest $request){
        $package=$this->model::whereProductId($request->product_id)->first();
        $units =$package->units +$package->points;
        auth()->user()->increment('units', $units);
        return $this->success("");
    }

}
