<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;
use App\Lib\bookeey;
use App\Models\Payment;
use App\Models\Package;
use App\Models\Country;
use App\Models\User;
use App\Models\PackageCountry;
use App\Http\Requests\Api\Payment\CheckRequest;

class PaymentController extends Controller
{
    use ResponsesTrait;
    public function payment(CheckRequest $request){
        $package=Package::whereProductId($request->product_id)->first();
        if($request->payment_method == 'knet'){
            $payment_method = 'knet';
            $price =$package->knet;
            if(!$price){
                return $this->failed("product not valid ");
            }
            
        }else if($request->payment_method == 'credit'){
            $payment_method = 'credit';
            if(!$package){
                return $this->failed("product not valid ");
            }
            $temp_price =PackageCountry::where(['country_id'=> auth()->user()->country_id,'package_id' => $package->id])->value('price') ;
            
            
            if($temp_price){
                $currency =Country::whereId(auth()->user()->country_id)->value('currency');
                $demoPrice = $this->convertCurrency($currency,$temp_price);
                if($demoPrice){
                    $price=$demoPrice;
                }else{
                    
                    $price= $package->price;
                }
            }else{
                $price= $package->price;
            }
        }
        $orderId=mt_rand(222222222222222, 999999999999999);
        
        $url = 'https://pg.bookeey.com/internalapi/api/payment/requestLink';
        //$url = 'https://apps.bookeey.com/pgapi/api/payment/requestLink';
        $hash= "mer2100031|$orderId|https://etmaaen.com/dreams/api/success|https://etmaaen.com/dreams/api/fail|$price|GEN|4409708|$orderId";
        $temp=hash('sha512', $hash);
        $jsonData = array(
            "DBRqst" => "PY_ECom",
            "Do_Appinfo" => array(
                 "APIVer" => "",
                "APPID" => "",
                "APPTyp" => "",
                "AppVer" => "",
                "Country" => "",
                "DevcType" => "5",
                "HsCode" => "",
                "IPAddrs" => "",
                "MdlID" => "",
                "OS" => "Android",
                "UsrSessID" => ""
            ),
            "Do_MerchDtl" => array(
                "BKY_PRDENUM" => "ECom",
                "FURL" => 'https://etmaaen.com/dreams/api/fail',
                "MerchUID" => "mer2100031",
                "SURL" => 'https://etmaaen.com/dreams/api/success'
            ),
            "Do_MoreDtl" => array(
                "Cust_Data1" => "",
                "Cust_Data2" => "",
                "Cust_Data3" => ""
            ),
            "Do_PyrDtl" => array(
                "Pyr_MPhone" => "",
                "Pyr_Name" => ""
            ),
            "Do_TxnDtl" => array(
                [
                    "SubMerchUID" => "mer2100031",
                    "Txn_AMT" => "$price"
                ]
                ),
            "Do_TxnHdr" => array(
                "BKY_Txn_UID" => "",
                "Merch_Txn_UID" => $orderId, //bill number
                "PayFor" => "ECom",
                "PayMethod" => $payment_method,
                "Txn_HDR" => "$orderId",
                "hashMac" => $temp
            )
        );
         $json = json_encode($jsonData);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
    
        $resp=json_decode($result, true);
        $data =
        [
            'order_id' => "$orderId" ,
            "user_id" => auth()->id() ,
            'status' => "pending" ,
            "product_id" => $package->id,
            "amount" => $price,
            'payment_method' => $payment_method
        ];
        Payment::create($data);
        return $this->success(["payment_url" =>$resp['PayUrl']]);

    }

    public function successUrl(Request $request){
        $merchantTxnId = $_GET['merchantTxnId']; 
        $payment=Payment::whereOrderId($merchantTxnId)->first();
        $package=Package::whereId($payment->product_id)->first();
        $units =$package->units +$package->points??0;
        $user = User::whereId($payment->user_id)->increment('units', $units);
        $payment->update(['status' => "success"]);
        return $this->success("عملية ناجحة");
    }

    public function failUrl(Request $request){
        $merchantTxnId = $_GET['merchantTxnId']; 
        Payment::whereOrderId($merchantTxnId)->update(['status' => "failed"]);
        return $this->failed("عملية غير ناجحة");
    }
    
    public function cron(){
        Payment::whereStatus('pending')->delete();
    }
    
    public function convertCurrency($from,$amt){
        $url="https://api.apilayer.com/currency_data/convert?to=USD&from=EGP&amount=20";
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => $url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            'apikey: 0QFJiK12j9BYFAy2ddfV6aiFbDb80RIp',
            'Accept: application/json',
            'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJhdWQiOiIzIiwianRpIjoiMGE5ZWYzMmIyZjgyNzE0MmJhYTdlYWVmYzViM2ZlZjdiZWUyODYyNGMyN2NjNGUzNDMzMDMwOGZmOTVlMDg4YWQ1ZmQ1ODI2ZTZkNDNiMzYiLCJpYXQiOjE2NjM4NDY4NTYuNTgxMjgsIm5iZiI6MTY2Mzg0Njg1Ni41ODEyODMsImV4cCI6MTY5NTM4Mjg1Ni41NzczNjIsInN1YiI6IjEiLCJzY29wZXMiOltdfQ.l9sxYQs4wJ5GizqbuLsXziR_8Mmd2NqZ9_O6D-nM-nmr24glOUc_z01HNWZR6MoW_572_LlQ6r1Cx9JibIHME25Q5yxbPN6KNYCAGZhjLmbsAUtVql0_FxttDfI12B64_ppi98lRDit-40tJBVp1KEAAJlvqDuia01yxdreToqGpgfPt9_fl5NbJmQPRpzgCQ1TWAbJlZbwQZ4vCJNmv3kem2I79wiDLHGeAp_PmVbUNDKby_x2Qegg4LObOqjn7X_eiMlRkZxCIheLWZHsNXVZ119CkAgaaBjneq9mslX3Sh_q3LlHlkEvWINauVesRJ4kTDRsvKTpiUvZA149FqYmBCKSO-khtwoqUcR_N8u3-mV1map_NS1UxIwHyzswpcou_FfujtqLaJALAFCWLpzu1rxxaih5s07pXUOcvgSdfY9sRQHKSTHnko0apTkxDBS-27Krlo02NOkudZRgpr9Adt1_5cRpK1VFnZXKzlp_xkr1W2pmbC_JKA5YwsH9HYbXhanp5f34qeOrAcxp_4FFTc02Pn5NP-Z37RWOleIZMPxbHkWuphEwYrcgfGCAn-lV0FP67FOvSboDuGK-TWhwipeS3at_j8NT8cN5NMkrxOdYhQ64ZiJTX9L9Jb0dA7gqNVloH6CuBIoC5NuirB_agZcymOWu9UFwUyyjKBYE'
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        $resp=json_decode($response, true);
        if($resp['success'] == true){
                return $resp['result'];
        }else{
            
            
        }
    }
}
