<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\EditProfileRequest;

class ProfileController extends Controller
{
    use ResponsesTrait;
    function index(){
        $user=auth()->user();
        return $this->success($user);
    }

    function change_unwatched_msg(){
        auth()->user()->update(['unwatched_msg' => false]);
        return $this->success(true);
    }
    
    function update(EditProfileRequest $request){
        $user=auth()->user();
        $data=$request->validated();

        if($request->hasFile('image')){
            if(Storage::exists("public/".$user->image))
            {
                Storage::delete("public/".$user->image);
            }
            $data['image']=substr($request->image->store('public/profiles'), 7);
        }
        elseif($request->image == "deleted"){

            if(Storage::exists("public/".$user->image))
                Storage::delete("public/".$user->image);
            
            $data['image']=null;
        }
        $user->update($data);
        return $this->success("تم التعديل بنجاح");
    }

    public function editOnline(){
        $user=auth()->user();
        $online['is_online']=!auth()->user()->is_online;
        auth()->user()->update($online);
        return $this->success('تم التعديل بنجاح');
    }
    
    public function destroy(Request $request){
        auth()->user()->delete();
        return $this->success('تم حذف حسابك بنجاح');
        
    }

}
