<?php

namespace App\Http\Controllers\Api\Users;

use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreConsultationDetailsRequest;
use Illuminate\Support\Facades\Validator;

class ConsultationsController extends Controller
{
    use ResponsesTrait;
    public function __construct()
    {
        $this->model = "App\Models\Consultation";
        $this->User = "App\Models\User";
        $this->Section = "App\Models\Section";
        $this->Discount = "App\Models\Discount";
        $this->Subscription = "App\Models\Subscription";
        $this->UserDiscounts = "App\Models\UserDiscounts";
        $this->ConsultationDetails = "App\Models\ConsultationDetails";
    }

    public function index()
    {
        $consultations = $this->model::with('section:id,name','consultantInfo:id,name,image,cover,is_online')
        ->withCount('details')
        ->whereUserId(auth()->id())
        ->orderByDESC('id')->get();
        return $this->success($consultations);
    }

    public function store(Request $request)
    {
        $rules =
        [
                'title' => 'required',
                'social_status' => 'required',
                'job_status' => 'required',
                'section_id' => 'required',
                'consultant_id' => 'required',
                'details' => 'required',
                'type' => 'required',
                'code' => 'sometimes|nullable',
            ];

        $messages = [];
        $valid = Validator::make(request()->all(), $rules, $messages);
        if ($valid->fails()) {
            return $this->failed($valid->messages()->first());
        }

        $consultation = $this->model::where(['section_id' => $request->section_id, 'country_id' => auth()->user()->country_id])->first();
        if (!$consultation) {
            $this->Section::whereId($request->section_id)->increment('countries_number');
        }
        $data = $request->only('title', 'section_id','consultant_id','job_status','social_status');
        $data['user_id'] = auth()->id();
        $data['country_id'] = auth()->user()->country_id;
        auth()->user()->increment('consultations_number');
        $consultant = $this->User::whereId($request->consultant_id)->first();
        $price=$consultant->consultation_price;
        
        $device_id = $consultant->device_id;
        // $consultant->increment('consultations_number');
        $consultant->update(['unwatched_msg' => true]);
        $consultation = $this->model::create($data);
        $data_send=[
            'type' => "2",
            'title' => "يوجد لديك رسالة جديدة",
            'message' => " لديك رسالة جديدة",
            'consultation_id' =>$consultation->id,
            'consultation_title' =>$consultation->title,
            'consultation_number' =>$consultation->consultation_number,
            'is_published' =>$consultation->is_published,
        ];
        
        if($device_id){
            $this->sendNotification($data_send,$users=[$device_id]);
        }
        $consultation->update(['consultation_number'=>$consultation->id+10000]);
        $data2['type'] = $request->type;
        $data2['details'] = $request->type == "text" ? $data2['details'] = $request->details : substr($request->details->store('public/records'), 7);
        $consultation->details()->create($data2);
        $code = $this->Discount::whereCode($request->code)->first();
        $subscription=[
            'user_id' => auth()->id(),
            'consultant_id' => $request->consultant_id,
            "value" => $price
        ];
        if($code){
            $this->UserDiscounts::create(["user_id" => auth()->id(),"discount_id" => $code->id]);
            $subscription['discount_id']=$code->id;
            $subscription['value']=$price-($price * ($code->value/100));
            $code->increment('used_coupons');
        } 
        auth()->user()->decrement('units',$subscription['value']);
        $this->Subscription::create($subscription);
        return $this->success("تم تسجيل الاستشارة بنجاح");
    }

    public function details(Request $request)
    {
        $consultation = $this->model::find($request->id);
        $user=$consultation->userInfo()->first(['name','image','birth_date']);
        $data['status']=$consultation->status;
        $data['details']=$consultation->details;
        $data['personal_data']=
        [
            'name' => $user->name,
            'age' => $user->birth_date->age,
            'social_status' => $consultation->social_status,
            'job_status' => $consultation->job_status
        ];
        if(auth()->user()->role == 2)
            $data['second_person']=$user;
        else
            $data['second_person']=$consultation->consultantInfo()->first(['name','image']);
        
        return $this->success($data);
    }

    public function addDetails(StoreConsultationDetailsRequest $request)
    {
        $data = $request->validated();
        $data['user_type'] = auth()->user()->role == 1 ? "user" : "consultant";
        $status=auth()->user()->role == 2 ? 2 : 3;
        if($request->type == "text" ){
            $data['details']=$request->details ;
        }else if($request->type == "record" ){
            $data['details']=substr($request->details->store('public/records'), 7);

        } else{
             $data['details']=substr($request->details->store('public/records'), 7);
        }
        
        // $data['details'] = $request->type == "text" ? $data2['details'] = $request->details : substr($request->details->store('public/records'), 7);
        $ConsultationDetails = $this->ConsultationDetails::create($data);
        if(auth()->user()->role == 2){
            
            $user=$this->User::find( $ConsultationDetails->consultation->user_id);
            $device_id = $user->device_id;
            $user->update(['unwatched_msg' => true]);
        }
        else{
            $consultant=$this->User::find( $ConsultationDetails->consultation->consultant_id);
            $device_id = $consultant->device_id;
            $consultant->update(['unwatched_msg' => true]);
        }
        
        $data_send=[
            'type' => "2",
            'title' => "يوجد لديك رسالة جديدة",
            'message' => " لديك رسالة جديدة",
            'consultation_id' =>$ConsultationDetails->consultation_id,
            'consultation_title' =>$ConsultationDetails->consultation->title,
            'consultation_number' =>$ConsultationDetails->consultation->consultation_number,
            'is_published' =>$ConsultationDetails->consultation->is_published,
        ];
        if($device_id){
            $this->sendNotification($data_send,$users=[$device_id]);
        }   
        $ConsultationDetails->consultation->update(['status' => $status]);
        return $this->success("تم تسجيل الرد بنجاح");
    }
    
    function sendNotification($data_send=array(),$users=array()){
        $content = ["en" => $data_send["message"]];
        $headings= ["en" => $data_send["title"]]; //<---- this will add heading
        $fields = array(
            'app_id' => '50fbd58c-8686-4f50-95d7-581eeaa3879f',
            'data' => $data_send,
            'isAndroid'=>true,
            'isIos'=>true,
            'content_available'=>true,
            'small_icon'    => 'ic_launcher-web',
            //'large_icon' =>"ic_launcher_round.png",
            'contents' => $content,
            'headings'=> $headings //<---- include it to request
        );

        if(empty($users))
        {
            $fields['included_segments']=array('All');
        }else
        {
            $fields['include_player_ids']=$users;
        }

        $fields = json_encode($fields);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic NzYwMDM2NjQtMzZlYy00MDEzLWEzYjQtMjBiNzhjYzIyOWRm'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        $response = curl_exec($ch);
        // var_dump($response);
        curl_close($ch);

        return $response;
    }
}
