<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class AddConsultantRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'name' => 'required|max:255',
            'password' => 'required',
            'country_id' => 'required',
            'phone' => 'required|unique:users',
            'response_rate' => 'required',
            'description' => 'required',
            'consultation_price' => 'required',
            'image' => 'required',
            'cover' => 'required',
            'birth_date' => 'required',
        ];
    }

  

    public function messages(): array {
        return [
            'phone.unique'  => 'The phone Is found.',
        ];
    }
}
