<?php

namespace App\Http\Requests\Info;

use Illuminate\Foundation\Http\FormRequest;

class EditRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id' => 'required',
            'title' => 'required',
            'msg' => 'required',
            'cover' => 'sometimes|nullable',
            'link' => 'sometimes|nullable',
            'start_date' => 'required',
            'end_date' => 'required',
        ];
    }
    
    public function messages(): array {
        return [
            'title.required'  => 'The code is title',
            'cover.required'  => 'The code is cover',
            'consultant_id.required'  => 'The code is consultant_id',
            'link.required'  => 'The code is link',
            'msg.required'  => 'The code is msg',
            "end_date.after_or_equal" =>'the end date should be after or equal today',
            "start_date.after_or_equal" =>'the start  date should be after or equal today'
        ];
    }
}
