<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ConsultantResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return 
        [
            'id' => $this->id,
            'is_online' => $this->is_online,
            'name' => $this->name,
            'image' => $this->image,
            'cover' => $this->cover,
            'response_rate' => $this->response_rate,
            'consultations_number' => $this->consultations_number,
            'consultation_price' => $this->consultation_price,
            'rate' => number_format($this->rating_number/($this->consultations_number==0?1:$this->consultations_number),2),
            'sections' => $this->sections()->get(['name']),
        ];
    }
}
