<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\PackageCountry;
class PackagesCreditResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return        
        [
            'id' => $this->id,
            'name' => $this->name,
            'product_id' =>$this->product_id,
            "units"=> $this->units,
            "points"=> (integer)$this->points,
            "price"=>  PackageCountry::where(['country_id'=> auth()->user()->country_id,'package_id' => $this->id])->value('price') ??$this->price
            
            

        ];
            
    }
}
