<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class Comment extends Model
{
    use HasFactory;
    protected $fillable = [
        'post_id',	'user_id',	'description'	
    ];

    protected $hidden = ['info_id','post_id','updated_at'];
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i');
    }
    public function userInfo()
    {
        return $this->hasOne(Consultant::class,'id','user_id');
    }
}
