<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;
    protected $fillable = 
    [
        'title_ar' , 'body_ar',
        'type' , 'consultant_id'
      
    ];

    protected $hidden = ['created_at' , 'updated_at'];

    public function consultant()
    {
        return $this->belongsTo(User::class, 'consultant_id','id')->withDefault([
            'name' => "بدون  خبير"
        ]);
    }
}
