<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;
    protected $fillable = 
    [
        'id' , 'user_id',
        'order_id' ,'status',
        'amount' , 'product_id',
        'payment_method'
    ];
    
    
    public function client(){
        return $this->belongsTo(User::class,'user_id','id');
    }
    
    public function package(){
        return $this->belongsTo(Package::class,'product_id','id');
    }
}
