<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id' , 'consultant_id',
        'discount_id' , "value"
    ];

    public function client(){
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function consultant(){
        return $this->belongsTo(User::class,'consultant_id','id');
    }
}
