<?php

namespace App\Models;

use Carbon\Carbon;
use DateTimeInterface;
use Laravel\Passport\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Authenticatable
{
    use SoftDeletes;
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = 
    [
        'name', 'image','cover',
        'phone', 'birth_date',
        'social_status', 'password',
        'country_id','device_id',
        'role','job_status','email',
        'consultation_price','description',
        'response_rate','is_online',
        'rating_number','consultations_number',
        'gender' , 'units' ,'unwatched_msg','deleted_at','active'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = 
    [
        // 'birth_date',
        'password',
        'remember_token',
        'device_id',
        'updated_at',
        'created_at',
        'deleted_at'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */

    protected $dates =[
        "birth_date"
    ];
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    public function setPasswordAttribute($value)
    {
        if($value != null)
            $this->attributes['password'] = bcrypt($value);
    }

    public function scopeConsultant($query)
    {
        return $query->where('role', 2);
    }
    
    public function scopeActive($query)
    {
        return $query->where('active', 1);
    }

    public function scopeOnline($query)
    {
        return $query->where('is_online', true);
    }

    public function scopeClient($query)
    {
        return $query->where('role', 1);
    }

    public function country(){
        return $this->belongsTo(Country::class);
    }

    public function consultations(){
        return $this->hasMany(Consultation::class,'consultant_id');
    }

    public function sections()
    {
        return $this->belongsToMany(Section::class, 'consultant_sections');
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d');
    }

}
