@extends('layouts.simple.master')
@section('title', 'Validation Forms')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>اضافة بانر</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">البانر</li>
<li class="breadcrumb-item active">اضافة  بانر</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
			@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
				<div class="card-body">
				     <div class="col-md-6 mb-3" >
                                <label for="validationCustom03">النوع</label>

                                <select class="js-example-placeholder-multiple col-sm-12"  id="type1"  name="type1" required onChange="changeVis(this.options[this.selectedIndex].value)">
                                    <option value=""></option>
                                     <option value="1">لينك خارجي</option>
                                     <option value="2">خبير</option>
                                     <option value="3">قسم</option>
                              
                                </select>
                                <div class="invalid-feedback">Please provide a valid type.</div>

                            </div>
					<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('banner.store') }}" id="tyu">
                        @csrf
						<div class="row">
						    
							 <div class="col-md-6 mb-3" style="display:none" id="ph1">
								<label for="validationCustom01">Url</label>
								<input class="form-control" id="validationCustom01" type="text" name="url" value="{{ old('url') }}" placeholder="Url" >
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a url.</div>
							</div>
                            
                            <div class="col-md-6 mb-3" style="display:none" id="ph2">
                                <label for="validationCustom03">الخبراء</label>

                                <select class="js-example-placeholder-multiple col-sm-12"  id="validationCustom033"  name="consultant_id"  >
                                    <option value="" selected></option>

                                    @forelse ($consultants as $section)

                                        <option value="{{ $section->id }}">{{ $section->name }}</option>
                                    @empty
                                        
                                    @endforelse
                              
                                </select>
                                <div class="invalid-feedback">Please provide a valid consultant.</div>

                            </div>
                            
                            <div class="col-md-6 mb-3" style="display:none" id="ph3">
                                <label for="validationCustom03">الاقسام</label>

                                <select class="js-example-placeholder-multiple col-sm-12"  id="validationCustom03"  name="section_id"  >
                                    <option value="" selected></option>

                                    @forelse ($sections as $section)

                                        <option value="{{ $section->id }}" >{{ $section->name }}</option>
                                    @empty
                                        
                                    @endforelse
                              
                                </select>
                                <div class="invalid-feedback">Please provide a valid section.</div>

                            </div>

						</div>

						<div class="row">
							
						</div>
						<div class="mb-3">
                           
                            <div class="col-md-12 mb-3">
                                <div class="col">
                                    <div class="mb-3 row">
                                        <label class="col-sm-3 col-form-label">Upload Cover</label>
                                        <div class="col-sm-9">
                                            <input class="form-control" type="file" name="cover" value="{{ old('image') }}" required accept="image/*">
                                        </div>
                                    </div>
                                </div>
                            </div>
							

						</div>
						<button class="btn btn-primary" type="submit">حفظ</button>
					</form>
				</div>
			</div>
			
		
		</div>
	</div>
</div>
@endsection

@section('script')

<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>

<script>
    
    function changeVis(chosen) {
        if(chosen){
            $("#tyu").find('select').select2().val('').trigger('change');

            document.getElementById("tyu").reset();
        if(chosen == 1){
            document.getElementById("ph2").style.display = "none";

            document.getElementById("ph3").style.display = "none";
            document.getElementById("ph1").style.display = "block";
            document.getElementById("ph1").attributes["required"] = "";  

        }
        else if (chosen ==2){
            document.getElementById("ph1").style.display = "none";
            document.getElementById("ph3").style.display = "none";
          const input = document.getElementById('validationCustom033');

            input.setAttribute('required', '');
            document.getElementById("ph2").style.display = "block";

            

        }
        else if (chosen ==3){
            document.getElementById("ph1").style.display = "none";
            document.getElementById("ph2").style.display = "none";
            document.getElementById("ph3").style.display = "block";
            const input = document.getElementById('validationCustom03');

            input.setAttribute('required', '');        }
        }
  
    }
</script>
@endsection