@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> البانرات</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">لوحة التحكم</li>
<li class="breadcrumb-item active">البانرات</li>
@endsection

@section('content')
<div class="container-fluid">

	<div class="row">
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<thead>
								<tr>
									<th>الخبير</th>
									<th>القسم</th>
									<th>Cover</th>
									<th>Url</th>
									<th></th>
									
								</tr>
							</thead>
							<tbody>
								@forelse ($banners as $banner)
									<tr>
										<td>{{ $banner?->userInfo?->name }}</td>
										<td>{{ $banner?->section?->name  }}</td>
										<td >
											<img src="{{ asset($banner->cover) }}"  alt=""  class="image-fluid"  height="90">
										</td>										
										<td>{{ $banner->url }}</td>
										
										<td>
											<!--<button class="btn btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal"  onclick="getRecord({{ $banner }})">تعديل</button>-->
										<form action="{{ route('admin.banner.delete',$banner->id) }}" onclick="getId({{ $banner->id }})" method="get" id="form_id">
                                                @csrf
                                                <input type="hidden" name="id" id="notification_id">
                                                <button id="{{ $loop->iteration }}" class="btn btn-danger sweet-5" onclick="test()" type="button" >حذف</button>
                                            </form>

										</td>
							
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
								<tr>
									<th>الخبير</th>
									<th>القسم</th>
									<th>Cover</th>
									<th>Url</th>
									<th></th>
								</tr>
							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">


	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">تعديل</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('banner.update') }}">
				@csrf
				<input type="hidden" id="section_id" name="id">
				<div class="row">
					<div class="col-md-12 mb-3">
						<label for="section_name">Url</label>
						<input class="form-control" id="section_name" type="text" name="url" value="" placeholder="Url" >
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a name.</div>
                        

					</div>
				
				</div>
				
				<div class="mb-3">
					<div class="col-md-12 mb-3">
						<div class="col">
							<div class="mb-3 row">
								<label class="col-sm-3 col-form-label">Cover</label>
								<div class="col-sm-9">
									<input class="form-control" type="file" name="cover"  accept="image/*">
								</div>
							</div>
						</div>
					</div>

				</div>
				{{-- <button class="btn btn-primary" type="submit">تعديل</button> --}}
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
					<button class="btn btn-secondary" type="submit">Save changes</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
 </div>

@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>


@endsection

<script>
	function getId(id){
	    document.getElementById("notification_id").value=id;
   }

	function getRecord(data){
	    document.getElementById("section_name").value=data['url'];
	    document.getElementById("section_id").value=data['id'];

   }
</script>