@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>العملاء</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">المستخدمون</li>
<li class="breadcrumb-item active">العملاء</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		

		<!-- Column rendering  Starts-->
		<div class="col-sm-12">
			<div class="card">
				{{-- <div class="card-header">
					<h5>Column rendering</h5>
					<span>Each column has an optional rendering control called <code class="option" title="DataTables initialisation option">columns.render:option</code>which can be used to process the content of each cell before the data is used. <code class="option" title="DataTables initialisation option">columns.render:option</code>has a wide array of
					options available to it for rendering different types of data orthogonally (ordering, searching, display etc), but it can be used very simply to manipulate the
					content of a cell, as shown here.</span><span>
					This example shows the person's age combined with their name in the first column, hiding the age column. This technique can be useful for adding links,
					assigning colours based on content rules and any other form of text manipulation you require.</span>
				</div> --}}
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<thead>
								<tr>
									<th>Name</th>
									<th class="text-center">Phone</th>
									<th class="text-center">Email</th>
									<th>Country</th>
									<th>Age</th>
									<th>Social Status</th>
									<th>Start date</th>
									<th class="text-center">Consultations Number</th>
									<th></th>								
								</tr>
							</thead>
							<tbody>
								@forelse ($clients as $client)
									<tr>
										<td>{{ $client->name }}</td>
										<td class="text-center">{{ $client->phone}}</td>
										<td>{{ $client->email}}</td>
										<td>{{ $client->country->name }}</td>
										<td>{{ $client->birth_date->age }}</td>
										<td>{{ $client->social_status }}</td>
										<td>{{ $client->created_at->format('Y-m-d') }}</td>
										<td class="text-center">{{ $client->consultations_number }}</td>
										<td>
											<button class="btn btn-primary" type="button" data-bs-toggle="modal" onclick="getRndInteger(),getId({{ $client->id }})" data-original-title="test" data-bs-target="#exampleModal" >reset Password</button>
                                            <form action="{{ route('admin.client.delete',$client->id) }}" onclick="getIdd({{ $client->id }})" method="get" id="form_id">
                                                @csrf
                                                <input type="hidden" name="id" id="notification_id">
                                                <button id="{{ $loop->iteration }}" class="btn btn-danger sweet-5" onclick="test()" type="button" >حذف</button>
                                            </form>
                                            
                                            <a href="{{ route('admin.change_status',$client->id) }}">
												<button class="btn btn-pill btn-primary">@if($client->active)
												الغاء التفعيل
												@else
												تفعيل
												
												@endif</button>
											</a>
										</td>
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
								<tr>
									<th>Name</th>
									<th>Phone</th>
									<th>Email</th>
									<th>Country</th>
									<th>Age</th>
									<th>Social Status</th>
									<th>Start date</th>
									<th>Consultations Number</th>
									<th></th>								
								</tr>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
		
	
	
	
	</div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">


	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">Reset Password</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST"  action="{{ route('admin.clients.reset_password') }}">
				@csrf
				<input type="hidden" id="client_id" name="client_id">
				<div class="row">
					<div class="col-md-12 mb-3">
						<label for="section_name">New Password</label>
						<input class="form-control" id="password" type="text" name="password" value="" placeholder="******" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a name.</div>

					</div>
				
				</div>
				
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
					<button class="btn btn-secondary" type="submit">Save changes</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
 </div>

@endsection
<script>
	function getRndInteger() {
  	let password=Math.floor(Math.random() * (99999999 - 11111111)) + 11111111;
	  document.getElementById("password").value=password;
	}

	function getId(id){
		document.getElementById("client_id").value=id;
	}
	function getIdd(id){
		document.getElementById("notification_id").value=id;
	}
	</script>
@section('script')

<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>
@endsection