@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/sweetalert2.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">


@endsection

@section('style')

@endsection

@section('breadcrumb-title')
<h3> التعليقات </h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">التعليقات </li>
<li class="breadcrumb-item active">عرض التعليقات</li>
@endsection

@section('content')
    <div class="container-fluid">

        <div class="row">
            
            <div class="col-sm-12 mt-3">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display" id="advance-1">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>المستخدم</th>
                                        <th>المحتوي</th>
                                        <th>التوقيت</th>
                                        <th></th>
                                        
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach ($comments as  $comment)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $comment->userInfo->name  }}</td>
                                        <td>
                                            <div>
                                            {{ $comment->description }}
                                            </div>
                                            </td>
                                        <td>
                                           {{ $comment->created_at->format('Y-m-d H:i:s') }}
                                        </td>
                                        <td>
                                            <form action="{{ route('admin.info.delete',$comment->id) }}" onclick="getId({{ $comment->id }})" method="get" id="form_id">
                                                @csrf
                                                <input type="hidden" name="id" id="notification_id">
                                                <button id="{{ $loop->iteration }}" class="btn btn-danger sweet-5" onclick="test()" type="button" >حذف</button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                                    
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>المستخدم</th>
                                        <th>التوقيت</th>
                                        <th></th>
                                
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        
        </div>

    </div>


@endsection

@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>

<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>

@endsection

<script>
	function getId(id){
	    document.getElementById("notification_id").value=id;
   }
</script>