@extends('layouts.simple.master')
@section('title', 'Validation Forms')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>اضافة خبير</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">الخبراء</li>
<li class="breadcrumb-item active">اضافة  خبير</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
			
				<div class="card-body">
					<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('consultants.store') }}">
                        @csrf
						<div class="row">
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">name</label>
								<input class="form-control" id="validationCustom01" type="text" name="name" value="{{ old('name') }}" placeholder="name" required="">
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>

							</div>
							<div class="col-md-6 mb-3">
								<label for="validationCustom02">Phone</label>
								<input class="form-control" id="validationCustom02" type="text" name="phone"  value="{{ old('phone') }}" placeholder="phone" required="">
								<div class="valid-feedback">Looks good!</div>
								@error('phone')
								<div class="alert alert-danger">{{ $message }}</div>
							 @enderror
							</div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom03">Sections</label>

                                <select class="js-example-placeholder-multiple col-sm-12"  id="validationCustom03"  name="sections[]" multiple="multiple" required="">
                                    @forelse ($sections as $section)

                                        <option value="{{ $section->id }}">{{ $section->name }}</option>
                                    @empty
                                        
                                    @endforelse
                              
                                </select>
                                <div class="invalid-feedback">Please provide a valid Sections.</div>

                            </div>

							<div class="col-md-6 mb-3">
                                <label for="validationCustom03">Countries</label>

                                <select class="js-example-placeholder-multiple col-sm-12"  id="validationCustom03"  name="country_id"  required="">
                                    @forelse ($countries as $country)
                                        <option value="{{ $country->id }}">{{ $country->name }}</option>
                                    @empty
                                        
                                    @endforelse
                              
                                </select>
                                <div class="invalid-feedback">Please provide a valid country.</div>

                            </div>


							<div class="col-md-6 mb-3">
                                <label for="validationCustom03">Gender</label>

                                <select class="form-control"  id="validationCustom03"  name="gender"  required="">
                                    <option value="male">ذكر</option>  
                                    <option value="female">انثي</option>  
                                </select>
                                <div class="invalid-feedback">Please provide a valid country.</div>

                            </div>
					
						</div>
						<div class="row">
						
							<div class="col-md-6 mb-3">
								<label for="validationCustom04">Response Rate</label>
								<input class="form-control" id="validationCustom04" type="text" placeholder="rate" name="response_rate" value="{{ old('response_rate') }}" required="">
								<div class="invalid-feedback">Please provide a valid state.</div>
							</div>
							<div class="col-md-6 mb-3">
								<label for="validationCustom05">Consultation Price</label>
								<input class="form-control" id="validationCustom05" type="number" placeholder="Price" name="consultation_price" value="{{ old('consultation_price') }}" required="">
								<div class="invalid-feedback">Please provide a valid Price.</div>
							</div>

								
							<div class="col-md-6 mb-3">
								<label for="validationCustom05">Birth Date</label>
								<input class="form-control" id="validationCustom05" type="date" placeholder="Price" name="birth_date" value="{{ old('birth_date') }}" required="">
								<div class="invalid-feedback">Please provide a valid date.</div>
							</div>

							<div class="col-md-6 mb-3">
								<label for="validationCustom05">Password</label>
								<input class="form-control" id="validationCustom05" type="password" placeholder="********" name="password" value="{{ old('password') }}" required="">
								<div class="invalid-feedback">Please provide a valid password.</div>
							</div>
						</div>

						<div class="row">
							
						</div>
						<div class="mb-3">
                            <div class="col-md-12 mb-3">
                                <div class="col">
                                    <div class="mb-3 row">
                                        <label class="col-sm-3 col-form-label">Upload image</label>
                                        <div class="col-sm-9">
                                            <input class="form-control" type="file" name="image" value="{{ old('image') }}" required accept="image/*">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-12 mb-3">
                                <div class="col">
                                    <div class="mb-3 row">
                                        <label class="col-sm-3 col-form-label">Upload Cover</label>
                                        <div class="col-sm-9">
                                            <input class="form-control" type="file" name="cover" value="{{ old('image') }}" required accept="image/*">
                                        </div>
                                    </div>
                                </div>
                            </div>
							

                            <div class="col-md-12 mb-3">
                                <div class="col">
                                    <div class="mb-3 mb-0">
                                        <label for="exampleFormControlTextarea4">CV</label>
                                        <textarea class="form-control" id="exampleFormControlTextarea4" name="description" rows="3" required>{{ old('description') }}</textarea>
                                    </div>
                                </div>
                            </div>
						</div>
						<button class="btn btn-primary" type="submit">حفظ</button>
					</form>
				</div>
			</div>
			
		
		</div>
	</div>
</div>
@endsection

@section('script')
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
@endsection