@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>الخبراء</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item"> المستخدمون</li>
<li class="breadcrumb-item active">الخبراء </li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		

		<!-- Column rendering  Starts-->
		<div class="col-sm-12">
			<div class="card">
				
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<thead>
								<tr>
									<th>Name</th>
									<th>Phone</th>
									<th>Section</th>
									<th>Country</th>
									<th>Age</th>
									<th>Start date</th>
									<th>Consultation Price</th>
									<th>Consultations Number</th>
									<th></th>
								</tr>
							</thead>
							<tbody>
								@forelse ($consultants as $consultant)
									<tr>
										<td>{{ $consultant->name }}</td>
										<td>{{ $consultant->phone }}</td>
										<td>
											
											@foreach ($consultant->sections as $section )
												{{ $section->name ??""}} <br>
											@endforeach
										</td>
										<td>{{ $consultant->country->name }}</td>
										<td>{{ $consultant->birth_date->age }}</td>
										<td>{{ $consultant->created_at->format('Y-m-d') }}</td>
										<td class="text-center">{{ $consultant->consultation_price }}</td>
										<td class="text-center">{{ $consultant->consultations_number }}</td>

										<td>
											<a href="{{ route('consultants.edit',$consultant->id) }}">
												<button class="btn btn-pill btn-primary">تعديل</button>
											</a>
											
											<form action="{{ route('admin.client.delete',$consultant->id) }}" onclick="getId({{ $consultant->id }})" method="get" id="form_id">
                                                @csrf
                                                <input type="hidden" name="id" id="notification_id">
                                                <button id="{{ $loop->iteration }}" class="btn btn-danger sweet-5" onclick="test()" type="button" >حذف</button>
                                            </form>
                                            <a href="{{ route('admin.change_status',$consultant->id) }}">
												<button class="btn btn-pill btn-primary">@if($consultant->active)
												الغاء التفعيل
												@else
												تفعيل
												
												@endif</button>
											</a>
										</td>
									</tr>
								@empty
									
								@endforelse
								
		
							</tbody>
							<tfoot>
								<tr>
									<th>Name</th>
									<th>Phone</th>
									<th>Section</th>
									<th>Country</th>
									<th>Age</th>
									<th>Start date</th>
									<th>Consultation Price</th>
									<th>Consultations Number</th>
									<th></th>
								</tr>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
		
	
	
	
	</div>
</div>
@endsection

@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>
<script>
    function getId(id){
		document.getElementById("notification_id").value=id;
	}
</script>
@endsection