@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>استشارات</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">استشارات</li>
<li class="breadcrumb-item active">استشارات</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<!-- Column rendering  Starts-->
		<div class="col-sm-12">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="" id="advance-1">
							<thead>
								<tr>
									<th>#</th>
									<th>Section</th>
									<th>Consultant</th>
									<th>Client</th>
									<th>Country</th>
									<th>Start date</th>
									<th>Status</th>
									<th></th>
								</tr>
							</thead>
							<tbody>

                              	@forelse ($consultations as $consultation)
									<tr>
										<td>{{ $consultation->consultation_number }}</td>
										<td>{{ $consultation->section->name }}</td>
										<td>{{ $consultation->consultantInfo->name ?? "تم حذف هذا الخبير"    }}</td>
										<td>{{ $consultation->userInfo->name ?? " تم حذف هذا العميل"  }}</td>
										<td>{{ $consultation->userInfo->country->name ?? "    "  }}</td>
										<td>{{ $consultation->created_at->format('Y-m-d') }}</td>
										<td>
											@php
												$diff=$consultation->updated_at->diffInDays($consultation->created_at);	
											@endphp
											@if ($consultation->status==1 && $diff>0)
										
													لم يتم الرد
												
											@elseif($consultation->status==1 && $diff<1)
											
													لم يتم الرد
												
											@elseif($consultation->status==2 || $consultation->status==3 )
											
													تم الرد
												
											@else
										
													تم الانتهاء
											
											@endif

										</td>
										<td>
											<a href="{{ route('admin.consultation.review',$consultation->id) }}">
												<button class="btn btn-pill btn-primary">مراجعة</button>
											</a>
										</td>
									</tr>
								@empty
									
								@endforelse
								
		
							</tbody>
							<tfoot>
								<tr>
									<th>#</th>
									<th>Section</th>
									<th>Consultant</th>
									<th>Client</th>
									<th>Country</th>
									
									<th>Start date</th>
									<th>Status</th>
									<th></th>
								</tr>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
		
	
	</div>
</div>
@endsection

@section('script')




  
    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
	<script>
		$(document).ready(function() {
			$('#advance-1').DataTable( {
			    select: true,
					
					"columnDefs": [
						{
							className: "Name", 
				// 			"targets":[0],
							"visible": true,
							"searchable":true
						},
						
						{ "orderable": false, "targets": [1,2,4,6] }
						
						],
					"order": [[ 0 ]],
			    
				initComplete: function () {
				    
					this.api().columns([1,2,4,6]).every( function () {
						
						var column = this;
						var select = $("<select class='form-control p-2'><option value=''></option></select>")
							.appendTo( $(column.header()).empty() )
							.on( 'change', function () {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
		
								column
									.search( val ? '^'+val+'$' : '', true, false )
									.draw();
							} );
		
						column.data().unique().sort().each( function ( d, j ) {
							select.append( '<option value="'+d+'">'+d+'</option>' )
						} );
					} );
				}
			} );
		} );
	</script>

<!--<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>-->
<!--<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>-->
@endsection