@extends('layouts.simple.master')
@section('title', 'Validation Forms')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>اضافة خصم</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">الخصومات</li>
<li class="breadcrumb-item active">اضافة   خصم</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
			
				<div class="card-body">
					<form class="needs-validation" novalidate="" method="POST" action="{{ route('discounts.store') }}">
                        @csrf
						<div class="row">
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">Code</label>
								<input class="form-control" id="validationCustom01" type="text" name="code" 
                                value="{{ old('code') }}" placeholder="code" required="">
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
                                @error('code')
								<div class="alert alert-danger">{{ $message }}</div>
							    @enderror

							</div>
							<div class="col-md-6 mb-3">
								<label for="validationCustom02">Total Coupons</label>
								<input class="form-control" id="validationCustom02" min="0" type="number" name="coupons_number"  value="{{ old('coupons_number') }}" placeholder="Total Coupons" required="">
								<div class="valid-feedback">Looks good!</div>
								@error('coupons_number')
								<div class="alert alert-danger">{{ $message }}</div>
							    @enderror
							</div>


                            <div class="col-md-6 mb-3">
								<label for="validationCustom04">User Coupons</label>
								<input class="form-control" id="validationCustom04" type="number" min="0" placeholder="User Coupons" name="coupons_user_number" 
                                value="{{ old('coupons_user_number') }}" required="">
								<div class="invalid-feedback">Please provide a valid User Coupons.</div>
							</div>
					
						</div>
						<div class="row">

							<div class="col-md-6 mb-3">
                                <label for="validationCustom03">Type</label>

                                <select class="js-example-placeholder-multiple col-sm-12"  id="validationCustom03"  name="type"  required="">
                                    <option value="percentage" @selected( old('type')=='percentage')>percentage</option>                                  
                                    {{-- <option value="cash" @selected( old('type')=='cash')>cash</option>                                   --}}
                                </select>
                                <div class="invalid-feedback">Please provide a valid Type.</div>

                            </div>

                            <div class="col-md-6 mb-3">
								<label for="validationCustom05">Value</label>
								<input class="form-control" id="validationCustom05" type="number" min="0" max="100" placeholder="Value" name="value" 
                                value="{{ old('value') }}" required="">
								<div class="invalid-feedback">Please provide a valid Value.</div>
                                @error('value')
								<div class="alert alert-danger">{{ $message }}</div>
							    @enderror
							</div>
						
							<div class="col-md-6 mb-3">
								<label for="validationCustom06">Start Date</label>
								<input class="form-control" id="validationCustom06" type="date" placeholder="Price" name="start_date" value="{{ old('start_date') }}" required="">
								<div class="invalid-feedback">Please provide a valid date.</div>
							</div>

							<div class="col-md-6 mb-3">
								<label for="validationCustom07">End Date</label>
								<input class="form-control" id="validationCustom07" type="date" placeholder="Price" name="end_date" value="{{ old('end_date') }}" required="">
								<div class="invalid-feedback">Please provide a valid date.</div>
                                @error('end_date')
								<div class="alert alert-danger">{{ $message }}</div>
							    @enderror
							</div>
						</div>

						
					
						<button class="btn btn-primary" type="submit">Save</button>
					</form>
				</div>
			</div>
			
		
		</div>
	</div>
</div>
@endsection

@section('script')
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
@endsection