@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>الخصومات</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">لوحة التحكم</li>
<li class="breadcrumb-item active">الخصومات</li>
@endsection

@section('content')
<div class="container-fluid">

	<div class="row">
		
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<thead>
								<tr>
									<th>#</th>
									<th>Code</th>
									<th>Total Coupons</th>
									<th>User Coupons</th>
									<th>Start Date</th>
									<th>End Date</th>
									<th>Type</th>
									<th>Value</th>
									<th></th>
									
								</tr>
							</thead>
							<tbody>
                                @foreach ($discounts as $discount )
                                    <tr>
                                        <td>{{$loop->iteration}}</td>
                                        <td>{{ $discount->code }}</td>
                                        <td>{{ $discount->coupons_number }}</td>
                                        <td>{{ $discount->coupons_user_number }}</td>
                                        <td>{{ $discount->start_date }}</td>
                                        <td>{{ $discount->end_date }}</td>
                                        <td>{{ $discount->type }}</td>
                                        <td>{{ $discount->value }}</td>
										<td>
											@if ($discount->active == true)
												<a class="btn btn-danger"  href="{{ route('change_active',$discount->id) }}" >الغاء التفعيل</a>

											@else
												<a class="btn btn-success"  href="{{ route('change_active',$discount->id) }}" >تفعيل</a>
											@endif
										</td>
                                    </tr>
                                @endforeach
							</tbody>
							<tfoot>
								<tr>
									<th>#</th>
									<th>Code</th>
									<th>Total Coupons</th>
									<th>User Coupons</th>
									<th>Start Date</th>
									<th>End Date</th>
									<th>Type</th>
									<th>Value</th>
									<th></th>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>

 </div>

@endsection

@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>

@endsection

<script>

</script>