@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> المعلومات</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">لوحة التحكم</li>
<li class="breadcrumb-item active">المعلومات</li>
@endsection

@section('content')
<div class="container-fluid">

	<div class="row">
	
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<thead>
								<tr>
								
									<th></th>
									
								</tr>
							</thead>
							<tbody>
								@forelse ($info as $item)
									<tr>
									    <td>
										<div class="default-according" id="accordionclose">
                    						<div class="card">
                    							<div class="card-header" id="heading{{$loop->iteration}}">
                    								<h5 class="mb-0">
                    									<button class="btn btn-link" data-bs-toggle="collapse" data-bs-target="#collapse{{$loop->iteration}}" aria-expanded="true" aria-controls="heading{{$loop->iteration}}">
                    									    {{$item->title}}&nbsp;&nbsp;&nbsp;<span>{{ $item->start_date }} - {{ $item->end_date }}</span>
                    									    </button>
                    								    
                    								</h5>
                    							</div>
                    							<div class="collapse" id="collapse{{$loop->iteration}}" aria-labelledby="heading1" data-bs-parent="#accordionclose">
                    								<div class="card-body">{{$item->msg}}</div>
                    								<img src="{{ asset($item->cover) }}"  alt=""  class="image-fluid"  width="320" height="240" >

                    								@if($item->type == 1)
        										        <img src="{{ asset($item->link) }}"  alt=""  class="image-fluid"  width="320" height="240" >
        										    @else
        											<video width="320" height="240" controls>
                                                      <source src="{{asset($item->link) }}" type="video/mp4">
                                                      error
                                                    </video>
        
        											 @endif
        											 <div class="row">
        											     <div class="col-md-4 mb-3">
            											 <button class="btn btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal"  
            											 onclick="getRecord({{ $item }})">Edit</button>
            											 </div>
            											 <div class="col-md-4 mb-3">
            											 <a href="{{ route('info.comments',$item->id) }}">
												        <button class="btn btn-pill btn-primary">مراجعة</button>
											            </a>
											            </div>
        											 <div class="col-md-4 mb-3">
        											 <form action="{{ route('info.destroy',$item->id) }}" onclick="getId({{ $item->id }})" method="post" id="form_id">
                                                @csrf
                                                @method('delete')
                                                <input type="hidden" name="id" id="notification_id">
                                                <button id="{{ $loop->iteration }}" class="btn btn-danger sweet-5" onclick="test()" type="button" >حذف</button>
                                            </form>
                                            </div>
                                            </div>

                    							</div>
                    					</div>
                    				</div>
							
							        </td>
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
								<tr>

									<th></th>
								</tr>
							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">


	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">Edit info</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('info.update') }}">
				@csrf
				<input type="hidden" id="section_id" name="id">
					@csrf
				<div class="row">
				    <div class="col-md-12 mb-3">
								<label for="validationCustom01">العنوان</label>
								<input class="form-control" id="title" type="text" name="title" value="{{ old('title') }}" placeholder="title" required="">
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a title.</div>

							</div>
				 <div class="col-md-12 mb-3">
                                <div class="col">
                                    <div class="mb-3 mb-0">
                                        <label for="exampleFormControlTextarea4">الوصف</label>
                                        <textarea class="form-control" id="exampleFormControlTextarea4" name="msg" rows="3" >{{ old('msg') }}</textarea>
                                    </div>
                </div>
                </div>
				
				</div>
				
										<div class="row">
							
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">تاريخ البداية</label>
								<input class="form-control" id="start_date" type="date" name="start_date" value="{{ old('start_date') }}" placeholder="title" required="">
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a title.</div>

							</div>
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">تاريخ النهاية</label>
								<input class="form-control" id="end_date" type="date" name="end_date" value="{{ old('end_date') }}" placeholder="title" required="">
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a title.</div>

							</div>
							
						</div>
				
				<div class="mb-3">
					<div class="col-md-12 mb-3">
						<div class="col">
							<div class="mb-3 row">
								<label class="col-sm-3 col-form-label">media</label>
								<div class="col-sm-9">
									<input class="form-control" type="file" name="link"   >
								</div>
							</div>
						</div>
					</div>

				</div>
				
				<div class="mb-3">
					<div class="col-md-12 mb-3">
						<div class="col">
							<div class="mb-3 row">
								<label class="col-sm-3 col-form-label">cover</label>
								<div class="col-sm-9">
									<input class="form-control" type="file" name="cover"   accept="image/*">
								</div>
							</div>
						</div>
					</div>

				</div>
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
					<button class="btn btn-secondary" type="submit">Save</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
 </div>

@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>



@endsection

<script>

	function getRecord(data){
	    document.getElementById("exampleFormControlTextarea4").value=data['msg'];
	    document.getElementById("title").value=data['title'];
	    document.getElementById("end_date").value=data['end_date'];
	    document.getElementById("start_date").value=data['start_date'];
	    document.getElementById("section_id").value=data['id'];
   }
   
   function getId(id){
	    document.getElementById("notification_id").value=id;
   }
</script>