@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/sweetalert2.css')}}">


@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> مدفوعات الباقات </h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">لوحة التحكم</li>
<li class="breadcrumb-item active">مدفوعات الباقات</li>
@endsection

@section('content')
<div class="container-fluid">

	<div class="row">
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display"  id="advance-1">
							<thead>
								<tr class="text-center">
									<th>Client</th>
									<th>Package</th>
									<th>Price</th>
									<th>Payment method</th>
									<th>Status</th>
									<th>Date</th>
									
								</tr>
							</thead>
							<tbody>
								@forelse ($subscriptions as $subscription)
									<tr class="text-center">
										<td>{{ $subscription->client->name ?? "تم حذف هذا العميل" }}</td>
										<td>{{ $subscription->package->name ?? " تم حذف هذه الباقة" }}</td>
										<td>{{ $subscription->amount }}</td>
										<td>{{ $subscription->payment_method }}</td>
										<td>
                                            @if ($subscription->status == 'success')
                                                <span class="badge badge-success">
                                                    Success
                                                </span>
                                            @elseif($subscription->status == 'failed')
                                                <span class="badge badge-primary">
                                                     Failed
                                                </span>
                                                
                                            @elseif($subscription->status == 'pending')
                                                <span class="badge badge-danger">
                                                   Pending
                                                </span>
                                            @endif
                                        </td>
										<td>{{ $subscription->created_at->format('Y-m-d H:i:s') }}</td>
																			
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
								<tr class="text-center">
                                    <th>Client</th>
                                    <th>Package</th>
									<th>Price</th>
									<th>Payment method</th>
									<th>Status</th>
									<th>Date</th>
                                </tr>
							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>






@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>

@endsection

<script>

	function getRecord(data){
	    document.getElementById("price").value=data['price'];
	    document.getElementById("units").value=data['units'];
	    document.getElementById("package_id").value=data['id'];
   }

   function getId(id){
	    document.getElementById("package_id").value=id;
   }
</script>