@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> @lang('lang.Sections') </h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">لوحة التحكم</li>
<li class="breadcrumb-item active">الاقسام</li>
@endsection

@section('content')
<div class="container-fluid">

	<div class="row">
		<div class="d-flex justify-content-end col-sm-12">
			<button class="btn btn-primary"  type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#addModal">Add</button>
		</div>
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<thead>
								<tr>
									<th>Name</th>
									<th>order Number</th>
									<th>Image</th>
									<th></th>
									
								</tr>
							</thead>
							<tbody>
								@forelse ($sections as $section)
									<tr>
										<td>{{ $section->name }}</td>
										<td>{{ $section->order_number }}</td>
										<td >
											<img src="{{ asset('storage/'.$section->image) }}"  alt=""  class="image-fluid"  height="90">
										</td>										
										
										<td>

											<button class="btn btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal"  onclick="getRecord({{ $section }})">Edit</button>
											{{-- <button class="btn btn-secondary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal">Delete</button> --}}

										</td>
							
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
								<tr>
									<th>Name</th>
									<th>order Number</th>
									<th>Image</th>
									
									<th></th>
								</tr>
							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">


	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">Edit Section</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('sections.update') }}">
				@csrf
				<input type="hidden" id="section_id" name="id">
				<div class="row">
					<div class="col-md-12 mb-3">
						<label for="section_name">name</label>
						<input class="form-control" id="section_name" type="text" name="name" value="" placeholder="name" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a name.</div>

					</div>
					
					<div class="col-md-12 mb-3">
						<label for="section_name">order number</label>
						<input class="form-control" id="order_number" type="number" name="order_number" value="" min='0' placeholder="name" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a order number.</div>

					</div>
				
				</div>
				
				<div class="mb-3">
					<div class="col-md-12 mb-3">
						<div class="col">
							<div class="mb-3 row">
								<label class="col-sm-3 col-form-label">Image</label>
								<div class="col-sm-9">
									<input class="form-control" type="file" name="image"  accept="image/*">
								</div>
							</div>
						</div>
					</div>

				</div>
				{{-- <button class="btn btn-primary" type="submit">Submit form</button> --}}
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
					<button class="btn btn-secondary" type="submit">Save changes</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
 </div>


<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">Add Section</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('sections.store') }}">
				@csrf
				<div class="row">
					<div class="col-md-12 mb-3">
						<label for="section_name">name</label>
						<input class="form-control" id="section_name" type="text" name="name" value="" placeholder="name" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a name.</div>

					</div>
				
				</div>
				
				<div class="mb-3">
					<div class="col-md-12 mb-3">
						<div class="col">
							<div class="mb-3 row">
								<label class="col-sm-3 col-form-label">Image</label>
								<div class="col-sm-9">
									<input class="form-control" type="file" name="image" required  accept="image/*">
								</div>
							</div>
						</div>
					</div>

				</div>
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
					<button class="btn btn-secondary" type="submit">Save changes</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
 </div>


@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>


@endsection

<script>

	function getRecord(data){
	    document.getElementById("section_name").value=data['name'];
	    document.getElementById("order_number").value=data['order_number'];
	    document.getElementById("section_id").value=data['id'];
   }
</script>