<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Route;



Route::get('test', [Api\PurchaseController::class, 'index']);
Route::get('callBack', [Api\PurchaseController::class, 'callBack'])->name('callBack');

// Mu'men
Route::get('consultations_sections', [Api\SectionsController::class, 'index']);

//Auth
Route::post('send_otp', [Api\Auth\ResetPasswordController::class, 'sendOtp']);
Route::post('reset_password', [Api\Auth\ResetPasswordController::class, 'resetPassword']);
Route::post('login', [Api\Auth\UserAuthController::class, 'login']);
Route::post('register', [Api\Auth\UserAuthController::class, 'register']);

//Country
Route::get('countries', [Api\CountriesController::class, 'index']);
// Cron
Route::get('cron', [Api\PaymentController::class, 'cron']);
Route::get('convertCurrency', [Api\PaymentController::class, 'convertCurrency']);

Route::get('success', [Api\PaymentController::class, 'successUrl']);
Route::get('fail', [Api\PaymentController::class, 'failUrl']);


Route::get('terms', [Api\AboutUsController::class, 'terms']);
Route::get('get_whatsapp_number', [Api\AboutUsController::class, 'index']);
Route::get('consultants', [Api\ConsultantsController::class, 'index']);
Route::get('consultant', [Api\ConsultantsController::class, 'show']);
Route::get('post', [Api\InfoController::class, 'details']);

Route::middleware(['auth:api'])->group(function () {
    
    Route::post('pay', [Api\PaymentController::class, 'payment']);

    //consultationsSections
    // Route::get('consultations_sections', [Api\SectionsController::class, 'index']);
    Route::get('sectionsList', [Api\SectionsController::class, 'sectionsList']);
    Route::post('like', [Api\InfoController::class, 'like']);
    Route::post('post', [Api\InfoController::class, 'store']);
    Route::get('consultant_posts', [Api\InfoController::class, 'consultantPosts']);
    Route::post('comment', [Api\CommentController::class, 'store']);
    Route::delete('comment', [Api\CommentController::class, 'destroy']);
    Route::get('comment', [Api\CommentController::class, 'index']);

    //Consultations
    Route::post('add_rate', [Api\EvaluationController::class, 'store']);
    Route::get('consultations', [Api\Users\ConsultationsController::class, 'index']);
    Route::post('consultations', [Api\Users\ConsultationsController::class, 'store']);
    Route::post('add_details_consultation', [Api\Users\ConsultationsController::class, 'addDetails']);
    Route::get('consultation_details', [Api\Users\ConsultationsController::class, 'details']);

    Route::post('end_consultation', [Api\Consultants\ConsultationsController::class, 'endConsultation']);
    Route::get('consultant_consultations', [Api\Consultants\ConsultationsController::class, 'index']);


    //Auth
    Route::get('logout', [Api\Auth\UserAuthController::class, 'logout']);
    Route::delete('delete_account', [Api\ProfileController::class, 'destroy']);

    //Profile
    Route::get('profile', [Api\ProfileController::class, 'index']);
    Route::post('edit_profile', [Api\ProfileController::class, 'update']);
    Route::get('change_unwatched_msg_status', [Api\ProfileController::class, 'change_unwatched_msg']);
    Route::get('edit_online', [Api\ProfileController::class, 'editOnline']);

    //Package
    Route::get('packages', [Api\PackageController::class, 'index']);

    Route::post('pay_package', [Api\PackageController::class, 'payPackage']);

    Route::post('check_availabilty', [Api\DiscountsController::class, 'checkAvailabilty']);

});
