<?php

namespace App\Http\Controllers\Admin;

use App\Models\Category;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Category\{StoreRequest,EditRequest};

class CategoryController extends Controller
{
    public function index(){
        $this->lang();
        $categories=Category::with("parent:id,$this->name")
        ->select('id','name_ar','name_en','image','end_point','parent_id')
        ->get();
        return view('admin.category.index',compact('categories'));  
    }

    public function create(){
        $this->lang();
        $categories=Category::whereEndPoint(0)->get(['id',$this->name]);
        return view('admin.category.add',compact('categories'));  
    }
    
    public function store(StoreRequest $request){
        Category::create($request->validated());
        return  to_route('category.index')->with('success',trans('lang.created')); 
    }

    public function update(EditRequest $request){
        $Category=Category::find($request->id);
        $Category->update($request->validated());
        return  to_route('category.index')->with('success',trans('lang.updated')); 
    }
}
