<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\{Seller,Product,City,User,Notification};
use App\Http\Requests\Admin\AddNotificationRequest;

class NotificationController extends Controller
{
    public function __construct()
    {
        $this->model="App\Models\Notification";
        $this->User="App\Models\User";
    }

    public function index(){
        #TODO complete
        $this->lang();
        $notifications=Notification::with(['seller:id,name',"region:id,$this->name","product:id,$this->name"])
        ->get();
        return view('admin.notifications.index',compact('notifications'));
    }

    public function create(){
        $this->lang();
        $sellers=Seller::get(['id','name']);
        $products=Product::get(['id',$this->name]);
        $regions = City::whereNotNull('parent_id')->get(['id',$this->name]);
        return view('admin.notifications.add',compact('sellers','products','regions'));
    }

    public function store(AddNotificationRequest $request){
        $data=$request->validated();
        Notification::create($data);
        // $notification=
        // [
        //     'type' => "1",
        //     'title' => $request->title_ar,
        //     'message' => $request->body_ar,
        //     'region_id' =>$request->region_id ,
        //     'product_id' =>$request->product_id ,
        //     'seller_id' =>$request->seller_id ,
        // ];
        // $subscribers=[];
        // if($request->region_id){
        //     $subscribers = User::whereRegionId($request->region_id)->pluck('device_id');
        // }
        // $this->sendMessage_onesignal_2app($data_send=$notification,$users=$subscribers);
        return  to_route('admin.notifications.index')->with('success',trans('lang.created'));
    }

    public function destroy(Request $request){
        Notification::destroy($request->id);
        return  to_route('admin.notifications.index')->with('success',trans('lang.deleted'));
    }

    function sendNotification($data_send=array(),$users=array()){
        #TODO complete

        $content = ["en" => $data_send["message"]];
        $headings= ["en" => $data_send["title"]]; //<---- this will add heading
        $fields = array(
            'app_id' => 'ebea10c6-b9d0-48a3-a8d6-b6f0d97d9d72',
            'data' => $data_send,
            'isAndroid'=>true,
            'isIos'=>true,
            'content_available'=>true,
            'small_icon'    => 'ic_launcher-web',
            //'large_icon' =>"ic_launcher_round.png",
            'contents' => $content,
            'headings'=> $headings //<---- include it to request
        );

        if(empty($users))
        {
            $fields['included_segments']=array('All');
        }else
        {
            $fields['include_player_ids']=$users;
        }

        $fields = json_encode($fields);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic YzFkNjdkMGEtNWI3ZS00MDZhLTgyZjgtZTM1OTAzMGY5YjA3'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

}
