<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use App\Models\{Category,User};
use App\Traits\ResponsesTrait;
use Illuminate\Http\Request;
use DB;
class CategoryController extends Controller
{
    use ResponsesTrait;
    public function mainCategories(){
        $this->lang();
        $categories = Category::whereNull('parent_id')
        ->select('id',$this->name,'image','end_point')
        ->get();
        return $this->success($categories);
    }

    public function categorySellers(Request $request){        
        $sellers = DB::table('sellers')
        ->join('category_seller','category_seller.seller_id','sellers.id')
        ->where('category_id',$request->category_id)
        ->get(['sellers.id','name']);
        return $this->success($sellers);
    }

    public function categoryUnderSeller(Request $request){     
        $parents=Category::whereId($request->category_id)->get();
        $id=$parents[0]['id'];
        $categories=[];
        $this->test($parents,$categories);
        return $this->success($categories[$id]);
    }


    public function index(Request $request){
        #TODO complete
        $this->lang();
        $parents=Category::whereNull('parent_id');
        if($request->name){
            $parents =$parents->where('name_ar', 'LIKE', "%{$request->name}%")
            ->orWhere('name_en', 'LIKE', "%{$request->name}%") ;
        }

        if($request->user_id){
            $user_region_id = User::find($request->user_id)->region_id;
            $user_region_id ;
            $sellers = DB::table('city_seller')->where('city_id',$user_region_id)->pluck('seller_id');
            $parents = $parents->with('sellers', function($q) use ($sellers){
                $q->whereIn('sellers.id', $sellers);
                $q->select('sellers.id','name');
            });
        }else{
            $parents = $parents->with('sellers:id,name');
        }
        $parents = $parents->select('id',$this->name,'image','end_point')
        ->orderBy('rank')
        ->get();

        $temp=[];
        $this->test($parents,$temp);
        return $this->success($temp);
    }
    
    public function test($parents,&$temp){
        $this->lang();
        foreach($parents as $parent){
            if(is_null($parent->parent_id)){
                if($parent->end_point ==0){
                    $parent->subCategories = $parent->subCategories()->where('end_point',1)
                    ->select('id',$this->name,'image','end_point','parent_id')
                    ->get();
                    $temp[$parent->id] = $parent;
                    $this->test($parent->subCategories()->where('end_point',0)->select('id',$this->name,'image','end_point','parent_id')->get(),$temp);
                }else{
                    $parent->subCategories = [];
                    $temp[$parent->id] = $parent;
                }
            }
            else{
                if($parent->end_point == 0)
                {
                    if(array_key_exists($parent->parent_id, $temp)){
                        $temp[$parent->parent_id]['subCategories'][]=$parent;
                        $this->test($parent->subCategories,$temp);
                    }
                    else
                        $this->test($parent->subCategories,$temp);
                }
                else{
                    if(array_key_exists($parent->parent_id, $temp))
                        $temp[$parent->parent_id]['subCategories'][]=$parent;  
                }
            }
        }
    }
}
