<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;
    protected $fillable = [
        'name_ar' ,'name_en',
        'description_en' , 'description_ar' ,
        'quantity' , 'price',
        'seller_id' , 'category_id',
        'main_image' ,'is_available',
        'picture'
    ]; 

    public function images(){
        return $this->hasMany(ProductImage::class);
    }
    
    public function seller(){
        return $this->belongsTo(Seller::class);
    }

    public function category(){
        return $this->belongsTo(Category::class,'category_id','id');
    }
}
