<?php

namespace App\Http\Controllers\Admin;

use App\Models\City;
use App\Models\User;
use App\Models\Order;
use Illuminate\Http\Request;
use App\Services\OrderService;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Order\AssignDriverRequest;
use App\Models\Driver;

class OrderController extends Controller
{
    public function index(){
        $orders=Order::with('user:id,name')->get();
        return view('admin.order.index',compact('orders'));
    }

    public function details($id){
        $this->lang();
        $order=Order::whereId($id)->with('user:id,name',"orderDetails.product:id,$this->name")->first();
        $region_id = User::find($order->user_id)->region_id;
        $city = City::find($region_id);
        $drivers_id = $city->drivers->pluck('pivot.driver_id');
        $drivers = Driver::whereIn('id',$drivers_id)->get(); 
        return view('admin.order.details',compact('order','drivers'));
    }

    public function changeOrderStatus($id,$action=null,OrderService $service){
        $request =(object) [
            "id" => $id,
            "action" => $action
        ];
        $service->changeOrderStatus($request);
        return to_route('order.index')->with('success',trans('lang.updated'));
    }

    public function assignDriver(AssignDriverRequest $request){
        $order = Order::find($request->id);
        $order->update(['driver_id' => $request->driver_id]);
        return to_route('order.index')->with('success',trans('lang.updated')); 
    }
}
