<?php

namespace App\Http\Controllers\Seller;

use App\Http\Controllers\Controller;
use App\Http\Requests\Seller\Order\EditStatusRequest;
use App\Models\Order;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function index(){
        $orders=Order::whereSellerId(auth()->id())->with('user:id,name')->get();
        return view('seller.order.index',compact('orders'));
    }

    public function details($id){
        $this->lang();
        $order=Order::whereId($id)->with('user:id,name',"orderDetails.product:id,$this->name")->first();
        return view('seller.order.details',compact('order'));
    }

    public function changeStatus(EditStatusRequest $request){
        #TODO complete
        Order::whereId($request->id)->update(['status' =>""]);
        return back()->with('success',trans('lang.updatted')); 
    }
}
