<?php

namespace App\Events;

use Illuminate\Support\Facades\Log;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class AvailableRidesEvent implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public $rides;
    public $driverIds;


    public function __construct($rides, $driverIds)
    {
        $this->rides = $rides;
        $this->driverIds = $driverIds;

        Log::info("AvailableRidesEvent triggered for driver IDs: " . json_encode($driverIds));
    }

    // public function broadcastOn()
    // {
    //     return new Channel('available-rides');
    // }
    public function broadcastOn()
    {
        return collect($this->driverIds)->map(function ($id) {
            return new PrivateChannel("drivers.{$id}");
        })->toArray(); 
    }

public function broadcastAs()
{
    return 'realtime-rides';
}

}
