<?php

namespace App\Events;

use App\Models\RideDriver;
use Illuminate\Support\Facades\Log;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class ClientRideRequestEvent implements ShouldBroadcast

{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */

     public $payload;

public function __construct(RideDriver $ride)
{
    Log::info("in Broadcasting ride :{$ride}");
    
    $startPoint = $ride->startPoint;

    $test =$this->payload = [
        'rideId' => $ride->id,
        'clientId' => $ride->client_id,
        'lat' => $startPoint->lat ?? null,
        'lang' => $startPoint->lang ?? null,
        'startTime' => $ride->created_at->toDateTimeString(),
        'vehicleType' => optional($ride->client)->vechile_type ?? null,
        'gender' => optional($ride->client)->gender ?? null,
        'totalDistance' => $ride->total_distance,
        'totalPrice' => $ride->total_price,
    ];
    Log::info("in Broadcasting payload :", $test);

}

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
        */
 public function broadcastOn()
{
    Log::info("in Broadcasting broadcastOn ");
    
    return new Channel('ride-requests'); // NOT PrivateChannel
}
public function broadcastWith()
{
    return $this->payload;
}

public function broadcastAs()
{
        Log::info("in Broadcasting broadcastAs ");
        return 'client-requested-ride';
    }
}
