<?php

namespace App\Events;
use Illuminate\Broadcasting\Channel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class TestBroadcastEvent implements ShouldBroadcast
{
    use Dispatchable, SerializesModels;

    public function broadcastOn()
    {
        return new Channel('ride-requests');
    }

    public function broadcastAs()
    {
        return 'test-event';
    }

    public function __construct()
    {
        $this->message = 'WebSocket is working!';
    }
}
