<?php

namespace App\Exports;

use App\Models\AuditLog;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\FromCollection;

class AuditLogExport implements FromCollection, WithHeadings, WithMapping
{
    /**
    * @return \Illuminate\Support\Collection
    */

    protected $startDate;
    protected $endDate;
    protected $search;

    // Accept date range via constructor
    public function __construct($startDate = null, $endDate = null, $search = null)
    {
        $this->startDate = $startDate;
        $this->endDate = $endDate;
        $this->search = $search;
    }
    public function collection()
    {
        $query = AuditLog::query();
    
        if ($this->startDate && $this->endDate) {
            $query->whereBetween('action_date', [$this->startDate, $this->endDate]);
        } elseif ($this->startDate) {
            $query->whereDate('action_date', '>=', $this->startDate);
        } elseif ($this->endDate) {
            $query->whereDate('action_date', '<=', $this->endDate);
        }
        if ($this->search) {
            $query->where(function ($q) {
                $q->where('driver_name', 'like', "%{$this->search}%")
                    ->orWhere('action_type', 'like', "%{$this->search}%")
                    ->orWhere('action_date', 'like', "%{$this->search}%");
            });
        }
    
        return $query->orderByDesc('action_date')->get();
    }
    


    public function map($auditLog): array
    {
        return [
            $auditLog->driver_name,  
            $auditLog->action_type, 
            $auditLog->action_date, 
        ];
    }

    public function headings(): array
    {
        // Define column headings
        return [
            __('lang.Name'),
            __('lang.action'),
            __('lang.date'),
        ];
    }
}
