<?php

namespace App\Exports;

use App\Models\Client;
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\WithHeadings;
class ClientsExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */


    public function headings(): array
    {
        // return ['ID', 'Name', 'city_id', 'phone','subscription_end_date','subscription_start_date','active','device_id','created_at'];
        return [
            '#',
            trans('lang.Name'),
            trans('lang.phone'),
            trans('lang.Status'),
            trans('lang.gender'),
            trans('lang.created_at'),
        ];
    }

    public function collection()
    {
        $clients=Client::query()
        ->select('name'  , 'phone' 
        ,'gender','active',
        'created_at')->get();







        $clients= $clients->map(function ($client ,  $num = 1) {
            if($client->active ==1){
                $active = trans('lang.active') ;
            }elseif ($client->active ==2) {
                $active = trans('lang.stop') ;
            } 
            else{
                $active = trans('lang.inactive') ;
            }

            // if ($client->gender == 'male') {
            //     $gender = (App::getLocale() == 'en') ? trans('lang.male') : trans('lang.ذكر');
            // } elseif ($client->gender == 'female') {
            //     $gender = (App::getLocale() == 'en') ? trans('lang.female') : trans('lang.أنثى');
            // } else {
            //     $gender = $client->gender ?? null;
            // }



            return [
                'indexa' => 1+ $num,
                'name' => $client->name ?? null,
                'phone' => $client->phone ?? null,
                'active' => $active,
                // 'gender' => $client->gender ?? null,
                'gender' => trans("lang.$client->gender") ?? null,
                'created_at' => $client->created_at ?? null,
            ];
        });
        

        return $clients;
    }
}
