<?php

namespace App\Exports;

use App\Models\RideBonus;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class RideBonusExport implements FromCollection, WithHeadings, WithMapping
{
    /**
    * @return \Illuminate\Support\Collection
    */




    public function headings(): array
    {
        return [
            __('lang.number'),      
            __('lang.Name'), 
            __('lang.description'), 
            __('lang.bonus_type'), 
            __('lang.bonus_value'),  
            __('lang.type'),
            __('lang.Status'),     
            __('lang.time_from'),   
            __('lang.time_to'),   
        ];
    }

    public function map($rideBonus): array
    {
        return [
            $rideBonus->rides_number,
            $rideBonus->bonus_name,
            $rideBonus->description,
            $rideBonus->bonus_type,
            $rideBonus->bonus_value,
            $rideBonus->type,
            $rideBonus->enable ? __('lang.enable') : __('lang.disable'),
            $rideBonus->time_from,
            $rideBonus->time_to,
        ];
    }
    public function collection()
    {
        return RideBonus::orderByDesc('updated_at')->get();
    }







}
