<?php

namespace App\Exports;

use App\Models\RideDriverDetails;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class RideDetailsExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */

    public function __construct($rideId)
    {
        $this->rideId = $rideId;
    }

    public function headings(): array
    {
        // Define column headings
        return [
            __('lang.Name'),
            __('lang.longitude'),
            __('lang.latitude'),
            __('lang.maps'),
        ];
    }

    public function collection()
    {
        // Fetch ride details with the required fields
        $rides = RideDriverDetails::select(
    'name',
            'lang',
            'lat',
        )->where('ride_driver_id', $this->rideId)->orderBy('created_at', 'desc')->get();
        $ride = $rides->map(function ($ride) {
            return [
                'name' => $ride->name,
                'lang' => $ride->lang,
                'lat' => $ride->lat,
                'map'=> "https://www.google.com/maps/search/?api=1&query=".$ride->lang.",".$ride->lat
            ];
        });
        return  $ride;
    }


}


