<?php

namespace App\Exports;

use App\Models\RideDriver;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class RideDriverExport implements FromCollection, WithHeadings, WithMapping
{
    /**
    * @return \Illuminate\Support\Collection
    */

    protected $rides;


    // Accept date range and search keyword via constructor
    public function __construct($rides)
    {
        $this->rides = $rides;
    }
    public function headings(): array
    {
        return [
            __('lang.clien_name'),
            __('lang.clien_phone'),
            __('lang.Name'),
            __('lang.phone'),
            __('lang.date'),
            __('lang.actual_price'),
            __('lang.actual_distance'),
            __('lang.status'),
            __('lang.startPoint'),
            __('lang.endPoint'),
            // __('lang.details'),
        ];
    }
    public function collection()
    {
        return $this->rides;
    }
    public function map($rideDriver): array
{
    return [
        $rideDriver->client->name ?? __('lang.not_available'),
        $rideDriver->client->phone ?? __('lang.not_available'),
        $rideDriver->user->name ?? __('lang.not_available'),
        $rideDriver->user->phone ?? __('lang.not_available'),
        $rideDriver->created_at ? $rideDriver->created_at->format('Y-m-d H:i:s') : __('lang.not_available'),
        number_format($rideDriver->actual_price, 2),
        number_format(str_replace(',', '', $rideDriver->actual_distance), 2),
        $rideDriver->status == 1 ? __('lang.complete') : __('lang.active'),
        $rideDriver->startPoint->name ?? __('lang.not_available'),
        $this->getEndPointName($rideDriver),
        
    ];
}

/**
 * Extracts the correct endPoint name.
 */
private function getEndPointName($rideDriver)
{
    if (!$rideDriver->endPoints || count($rideDriver->endPoints) === 0) {
        return __('lang.not_available');
    }

    return collect($rideDriver->endPoints)
        ->where('is_end_point', 1)
        ->pluck('name')
        ->implode("\n------------------------------\n");
}

}
