<?php

namespace App\Exports;

use App\Models\User;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class UsersExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */

    public function lang(){
        if(app()->getLocale() == "en" || request()->header('Lang') == "en"){
            $this->locale="name_en as name";
            $this->description="description_en as description";
        }else{
            $this->locale="name_ar as name";
            $this->description="description_ar as description";
        }
    }

    public function headings(): array
    {
        // return ['ID', 'Name', 'city_id', 'phone','subscription_end_date','subscription_start_date','active','device_id','created_at'];
        return [
            '#',
            trans('lang.Name'),
            trans('lang.phone'),
            trans('lang.region'),
            trans('lang.Status'),
            trans('lang.joining_date'),
            trans('lang.subscription_start_date'),
            trans('lang.subscription_end_date'),
        ];
    }
    public function collection()
    {
        $this->lang();
        $clients=User::query()->with("region:id,$this->locale");
        $clients =$clients
        ->select('users.id' ,'users.name' ,'city_id' , 'users.phone' 
        ,'subscription_end_date','subscription_start_date','active','users.device_id',
        'users.created_at')->get();

        // Log::info( $clients);
        $clients= $clients->map(function ($clients ,  $num = 1) {
            if($clients->active ==1){
                $active = trans('lang.active') ;
            }elseif ($clients->active ==2) {
                $active = trans('lang.stop') ;
            } 
            else{
                $active = trans('lang.inactive') ;
            }
            return [
                'indexa' => 1+ $num,
                'name' => $clients->name ?? null,
                'phone' => $clients->phone ?? null,
                'region' => $clients->region->name ?? null,
                'active' => $active,
                'created_at' => $clients->created_at ?? null,
                'subscription_start_date' => $clients->subscription_start_date?->format('Y-m-d') ?? null,
                'subscription_end_date' => $clients->subscription_end_date?->format('Y-m-d') ?? null,
            ];
        });
        return $clients;
    }

}
