<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\DriverEditRequest;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use SebastianBergmann\CodeCoverage\Driver\Driver;

class AdminEditRequestController extends Controller
{
    public function index()
    {
        // Fetch all pending requests with related driver data
        $requests = DriverEditRequest::with('user')->orderByDesc('created_at')->get();
        // $requests = DriverEditRequest::get();
        // Log::info($requests);

        return view('admin.editRequests.index', compact('requests'));
    }

    public function update(Request $request, $id)
    {
        $editRequest = DriverEditRequest::with('user')->findOrFail($id);

        

        $driver=User::find($editRequest->driver_id);
        Log::info($driver);
        if ($request->input('action') === 'approve') {
            // Update driver profile
            if ($driver) {
                if ($editRequest->phone) {
                    $driver->phone = $editRequest->phone;
                }
            
                if ($editRequest->car_color) {
                    $driver->car_color = $editRequest->car_color;
                }
            
                if ($editRequest->car_license) {
                    $driver->car_license = $editRequest->car_license;
                }
            
                if ($editRequest->driving_license) {
                    $driver->driving_license = $editRequest->driving_license;
                }
            
                if ($editRequest->image) {
                    $driver->image = $editRequest->image;
                }
            
                if ($editRequest->model_year) {
                    $driver->model_year = $editRequest->model_year;
                }
            
                if ($editRequest->car_type_id) {
                    $driver->car_type_id = $editRequest->car_type_id;
                }
            
                if ($editRequest->car_model_id) {
                    $driver->car_model_id = $editRequest->car_model_id;
                }
            
                // Save the driver with the updated fields
                $driver->save();
            } 

            // Mark the request as approved
            $editRequest->update(['request_status' => 'approved']);
        }  else {
            // Handle rejection with reason
            $rejectionReason = $request->input('rejection_reason');
    
            // Validate rejection reason is provided
            if (!$rejectionReason) {
                return redirect()->back()->withErrors(['rejection_reason' => 'Rejection reason is required.']);
            }
    
            // Mark the request as rejected and add the rejection reason
            $editRequest->update([
                'request_status' => 'rejected',
                'rejection_reason' => $rejectionReason
            ]);
        }

        return redirect()->route('admin.edit_requests.index')->with('status', 'Request updated successfully.');
    }
    public function details($id)
    {
        $editRequest = DriverEditRequest::with('user')->findOrFail($id);
        return view('admin.editRequests.details', compact('editRequest'));
    }


}
