<?php

namespace App\Http\Controllers\Admin;

use App\Models\AuditLog;
use Illuminate\Http\Request;
use App\Exports\AuditLogExport;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Requests\Admin\AuditLog\AuditLogExportRequest;

class AuditLogController extends Controller
{
    public function index(Request $request)
{
    // If no date filters are provided, return an empty result
    if (!$request->filled('start_date') && !$request->filled('end_date')) {
        return view('admin.audit_logs.index', ['auditLog' => null]); // No data until a filter is applied
    }

    // Start query
    $result = AuditLog::query();

    // Apply filtering based on available date inputs
    if ($request->filled('start_date') && $request->filled('end_date')) {
        $result->whereBetween('action_date', [$request->start_date, $request->end_date]);
    } elseif ($request->filled('start_date')) {
        $result->whereDate('action_date', '>=', $request->start_date);
    } elseif ($request->filled('end_date')) {
        $result->whereDate('action_date', '<=', $request->end_date);
    }

    // Fetch the filtered result
    $auditLog = $result->orderByDesc('action_date')->get();

    return view('admin.audit_logs.index', compact('auditLog'));
}



    public function export(AuditLogExportRequest $request)
    {
        // Validate incoming request
        $request->validated();

        // Get date range from frontend
        $startDate = $request->start_date;
        $endDate = $request->end_date;
        $search = $request->search;

        // Export with the specified date range
        return Excel::download(new AuditLogExport($startDate, $endDate,$search), 'audit_logs.xlsx');
    }
}
